<?php
// ++=========================================================================++
// || vBadvanced Gallery v1.0.1 (vB 3.5) - nulled by someone@mail.ru
// || http://vbadvanced.com
// ++ ========================================================================++

error_reporting(E_ALL & ~E_NOTICE);
define('NO_REGISTER_GLOBALS', 1);

// ############################# Resize Image #################################
function resize_image($widthsize, $heightsize, $original = 0, $nameonly = false, $savepath = '')
{
	global $imageinfo, $vba_options, $userid, $catoptions;

	if (empty($catoptions["$imageinfo[catid]"]))
	{
		$catoptions["$imageinfo[catid]"] = fetch_adv_category_setting($imageinfo['catid']);
	}

	if ($heightsize AND $widthsize)
	{
		$heightpercent = $imageinfo['height'] / $heightsize;
		$widthpercent = $imageinfo['width'] / $widthsize;
	}

	if ($heightpercent > 1 OR $widthpercent > 1)
	{
		if ($widthpercent > $heightpercent)
		{
			$shrinkage = $widthsize / $imageinfo['width'];
		}
		else
		{
			$shrinkage = $heightsize / $imageinfo['height'];
		}

		$newheight = round($shrinkage * $imageinfo['height']);
		$newwidth = round($shrinkage * $imageinfo['width']);

		if ($savepath)
		{
			$savepath = $savepath;
		}
		else if ($original)
		{
			$savepath = $imageinfo['location'];
		}
		else if ($vba_options['gallery_resizemethod'] == 'IM' OR (in_array($vba_options['gallery_resizemethod'], array('GD1', 'GD2')) AND in_array($imageinfo['numericaltype'], array(1,2,3))))
		{
			$imageinfo['thumbname'] = $imageinfo['shortname'] . '_thumb.' . $imageinfo['extension'];
			$savepath = $imageinfo['saveto'] . '/' . $imageinfo['thumbname'];
		}
		else
		{
			$imageinfo['thumbname'] = '';
		}

		if ($nameonly)
		{
			return $imageinfo;
		}

		// Now let's resize it
		modify_image($savepath, $newwidth, $newheight, iif($original, $catoptions["$imageinfo[catid]"]['gallery_origquality'], $catoptions["$imageinfo[catid]"]['gallery_thumbquality']));

		// New image info if resizing original
		if ($original == 1)
		{
			$imageinfo['width'] = $newwidth;
			$imageinfo['height'] = $newheight;
			clearstatcache();
			$imageinfo['filesize'] = @filesize($imageinfo['location']);
		}
	}
	else
	{
		// Else we're not resizing
		if (!$original AND !$imageinfo['thumbname'])
		{
			$imageinfo['thumbname'] = $imageinfo['saveas'];
		}
	}

	return $imageinfo;
}

// ########################### Resize or Change Quality #######################
function modify_image($savepath, $width, $height, $quality)
{
	global $vba_options, $imageinfo, $vbulletin;

	switch ($vba_options['gallery_resizemethod'])
	{
		// Use GD to Resize
		case 'GD1':
		case 'GD2':
			switch ($imageinfo['numericaltype'])
			{
				// JPG Image
				case 2:
					$src_img = @imagecreatefromjpeg($imageinfo['location']);
					if ($width AND $height)
					{
						if ($vba_options['gallery_resizemethod'] == 'GD1')
						{
							$dst_img = @imagecreate($width, $height);
							@imagecopyresized($dst_img, $src_img, 0, 0, 0, 0, $width, $height, $imageinfo['width'], $imageinfo['height']);
						}
						else
						{
							$dst_img = @imagecreatetruecolor($width, $height);
							@imagecopyresampled($dst_img, $src_img, 0, 0, 0, 0, $width, $height, $imageinfo['width'], $imageinfo['height']);
						}
					}
					else
					{
						$dst_img = $src_img;
					}
					@imagejpeg($dst_img, $savepath, $quality);
					break;

				// PNG Image
				case 3:
					$src_img = @imagecreatefrompng($imageinfo['location']);
					$dst_img = @imagecreate($width, $height);
					@imagecopyresized($dst_img, $src_img, 0, 0, 0, 0, $width, $height, $imageinfo['width'], $imageinfo['height']);
					@imagepng($dst_img, $savepath);
					break;

				case 1:
					if (function_exists('imagegif') AND function_exists('imagecreatefromgif'))
					{
						$src_img = @imagecreatefromgif($imageinfo['location']);
						$trans = @imagecolortransparent($src_img);
						$dst_img = @imagecreate($width, $height);
						@imagepalettecopy($dst_img, $src_img);
						@imagefill($dst_img, 0, 0, $trans);
						@imagecolortransparent($dst_img, $trans);
						@imagecopyresized($dst_img,$src_img, 0, 0, 0, 0, $width, $height, $imageinfo['width'], $imageinfo['height']);
						@imagegif($dst_img, $savepath);
					}
					break;
			}

			@imagedestroy($src_img);
			@imagedestroy($dst_img);

			break;

		// Use ImageMagick to Resize
		case 'IM':

			if ($quality == -1)
			{
				$quality = '';
			}

			$IMcommand = '"' . $vba_options['gallery_programpath'] . 'convert" ' . iif($width AND $height, '-size ' . $width . 'x' . $height. ' -geometry ' . $width . 'x' . $height) . iif($quality, ' -quality ' . $quality) . ' ' . $imageinfo['location'] . iif($imageinfo['extension'] == 'gif', '[0]') . ' ' . $savepath;

			@system($IMcommand, $IMerror);

			if (!in_array($IMerror, array(0, 1)))
			{
				@unlink($imageinfo['location']);
				eval(standard_error(fetch_error('adv_gallery_im_error', $vbulletin->options['webmasteremail'], $IMerror, $IMcommand)));
			}

			break;
	}
}

// ############################# Process Upload ###############################
function process_upload($thumbcreated = false, $new = true)
{
	global $db, $vbulletin, $galleryperms, $vba_options, $imageinfo, $imageoptions, $customfields, $userinfo, $categoryperms, $imgtypearray, $filetypes, $userid, $username, $catoptions, $massimageinfo;
	static $errors;

	if (empty($catoptions["$imageinfo[catid]"]))
	{
		$catoptions["$imageinfo[catid]"] = fetch_adv_category_setting($imageinfo['catid']);
	}

	$userinfo['usedspace'] += $imageinfo['filesize'];
	// Make sure the user has enough space on their account
	if ($galleryperms['gallery_maxdiskspace'] AND $galleryperms['gallery_maxdiskspace'] < $userinfo['usedspace'])
	{
		eval(standard_error(fetch_error('adv_gallery_nodiskspace', $imageinfo['filesize'], ($galleryperms['gallery_maxdiskspace'] - $userinfo['usedspace']))));
	}

	if (function_exists('exif_read_data'))
	{
		$exif = @exif_read_data($vba_options['gallery_filedirectory'] . '/' . implode('/', preg_split('//', $userid, -1, PREG_SPLIT_NO_EMPTY)) . '/' . $imageinfo['saveas'], 'EXIF');
	}

	$imageinfo = resize_image($catoptions["$imageinfo[catid]"]['gallery_thumbsize'], $catoptions["$imageinfo[catid]"]['gallery_thumbsize'], 0, iif($new OR $catoptions["$imageinfo[catid]"]['gallery_thumbsize'] != $catoptions["$massimageinfo[catid]"]['gallery_thumbsize'], false, true));

	// Get original image info
	if ($catoptions["$imageinfo[catid]"]['gallery_saveoriginal'] AND ($imageinfo['width'] > $filetypes["$imageinfo[catid]"]["$imageinfo[extension]"]['width'] OR $imageinfo['height'] > $filetypes["$imageinfo[catid]"]["$imageinfo[extension]"]['height']))
	{
		$imageinfo['originalname'] = $imageinfo['shortname'] . '_original.' . $imageinfo['extension'];
		@copy($imageinfo['location'], $imageinfo['saveto'] . '/' . $imageinfo['originalname']);
		$imageinfo['originalfilesize'] = $imageinfo['filesize'];
		$imageinfo['originalwidth'] = $imageinfo['width'];
		$imageinfo['originalheight'] = $imageinfo['height'];
		// Reduce the quality if necessary
		if (!in_array($catoptions["$imageinfo[catid]"]['gallery_origquality'], array(-1, 100)) AND $imageinfo['numericaltype'] != 1)
		{
			modify_image($imageinfo['saveto'] . '/' . $imageinfo['originalname'], $imageinfo['width'], $imageinfo['height'], $catoptions["$imageinfo[catid]"]['gallery_origquality']);
			clearstatcache();
			$imageinfo['originalfilesize'] = @filesize($imageinfo['saveto'] . '/' . $imageinfo['originalname']);
		}
	}

	$imageinfo = resize_image($filetypes["$imageinfo[catid]"]["$imageinfo[extension]"]['width'], $filetypes["$imageinfo[catid]"]["$imageinfo[extension]"]['height'], 1);

	// Watermark Image
	if ($catoptions["$imageinfo[catid]"]['gallery_watermark'] AND $vba_options['gallery_permwatermark'])
	{
		watermark_image('normal', true);
		clearstatcache();
		$imageinfo['filesize'] = @filesize($imageinfo['location']);

		if ($imageinfo['originalname'])
		{
			watermark_image('original', true);
			$imageinfo['originalfilesize'] = @filesize($imageinfo['saveto'] . '/' . $imageinfo['originalname']);
		}
	}

	if (!trim($imageinfo['title']))
	{
    $imageinfo['title'] = $imageinfo['shortname'];
	}

	$valid = iif($categoryperms["$imageinfo[catid]"]['moderateimages'], 0, 1);

	if ($new)
	{
		$db->query_write("INSERT INTO " . TABLE_PREFIX . "adv_gallery_images (title, description, keywords, catid, dateline, userid, username, extension, filename, filesize, width, height, thumbname, originalname, originalfilesize, originalwidth, originalheight, valid, open, ipaddress) VALUES ('" . addslashes(htmlspecialchars($imageinfo['title'])) . "', '" . addslashes($imageinfo['description']) . "', '" . addslashes(htmlspecialchars($imageinfo['keywords'])) . "', '$imageinfo[catid]', '" . time() . "', '$userid', '" . addslashes($username) . "', '$imageinfo[extension]', '" . addslashes($imageinfo['saveas']) . "', '$imageinfo[filesize]', '$imageinfo[width]', '$imageinfo[height]', '" . addslashes($imageinfo['thumbname']) . "', '" . htmlspecialchars(addslashes($imageinfo['originalname'])) . "', '$imageinfo[originalfilesize]', '$imageinfo[originalwidth]', '$imageinfo[originalheight]', '$valid', 1, '" . addslashes(IPADDRESS) . "')");

		$newimageid = $db->insert_id();

		if ($catoptions["$imageinfo[catid]"]['gallery_uploadpostcount'])
		{
			$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "user SET posts = posts+1 WHERE userid = '$userid'");
		}

		if (!empty($exif))
		{
			$db->query_write("INSERT INTO " . TABLE_PREFIX . "adv_gallery_exif (imageid, exifinfo) VALUES ('$newimageid', '" . iif($exif, addslashes(serialize($exif))) . "')");
		}

		if ($imageoptions['favorite'])
		{
			$db->query_write("INSERT INTO " . TABLE_PREFIX . "adv_gallery_favorites (userid, imageid) VALUES ('" . $vbulletin->userinfo['userid'] . "', '$newimageid')");
		}

		if ($imageoptions['subscribe'])
		{
			$db->query_write("INSERT INTO " . TABLE_PREFIX . "adv_gallery_subscribeimage (userid, imageid) VALUES ('" . $vbulletin->userinfo['userid'] . "', '$newimageid')");
		}

		construct_customfields_sql($customfields, $newimageid);

		if ($valid)
		{
			$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "adv_gallery_categories SET imagecount = imagecount+1, lastimageid = '$newimageid', lastimageuserid = '$userid', lastimageusername = '" . addslashes($username) . "', lastimagetitle = '" . htmlspecialchars(addslashes($imageinfo['title'])) . "', lastimagedateline = '" . TIMENOW . "' WHERE catid = '$imageinfo[catid]'");
		}
	}
	else
	{
		$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "adv_gallery_images SET filename = '$imageinfo[saveas]', filesize = '$imageinfo[filesize]', width = '$imageinfo[width]', height = '$imageinfo[height]', thumbname = '$imageinfo[thumbname]', originalname = '$imageinfo[originalname]', originalfilesize = '$imageinfo[originalfilesize]', originalwidth = '$imageinfo[originalwidth]', originalheight = '$imageinfo[originalheight]', ipaddress = '" . IPADDRESS . "' WHERE imageid  = '$imageinfo[imageid]'");
		if (!empty($exif))
		{
			$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "adv_gallery_exif SET exifinfo = '" . addslashes(serialize($exif)) . "' WHERE imageid = '$imageinfo[imageid]'");
		}
	}
	@chmod($imageinfo['location'], 0777);

	return $newimageid;
}

// ######################## Fetch Random Image Name ###########################
function fetch_random_imagename($filename, $existsarray)
{
	$randfilename = substr($filename, '', strrpos($filename, '.')) . '_' . rand(0, 999999) . '.' . substr($filename, strrpos($filename, '.') + 1);

	if (!in_array($randfilename, $existsarray))
	{
		return $randfilename;
	}
	else
	{
		fetch_random_imagename();
	}
}

// ############################# Fetch Image Info #############################
function fetch_image_info($location, $filename, $adduser = false)
{
	global $db, $vba_options, $imageinfo, $folderstring, $server, $vbulletin, $userid;

	$imginfo['truename'] = $filename;
	$filename = preg_replace("/[^a-z_.0-9-]/i", '', $filename);

	$existsarray = array();
	$exists = $db->query_read("SELECT filename, originalname, thumbname FROM " . TABLE_PREFIX . "adv_gallery_images WHERE userid = '$userid' AND (filename LIKE '" . addslashes($filename) . "%' OR thumbname LIKE '" . addslashes($filename) . "%' OR originalname LIKE '" . addslashes($filename) . "%')");
	while ($exist = $db->fetch_array($exists))
	{
		$existsarray[] = $exist['filename'];
		$existsarray[] = $exist['thumbname'];
		$existsarray[] = $exist['originalname'];
	}
	if (!empty($existsarray))
	{
		$imginfo['filename'] = fetch_random_imagename($filename, $existsarray);
	}
	else
	{
		$imginfo['filename'] = $filename;
	}

	if ($server['upload'] AND $imageinfo['filename'] != $imginfo['truename'])
	{
		@rename($location, $vba_options['gallery_userfolder'] . '/' . $vbulletin->userinfo['userid'] . '/' . $imginfo['filename']);
		$location = $vba_options['gallery_userfolder'] . '/' . $vbulletin->userinfo['userid'] . '/' . $imginfo['filename'];
	}

	$imginfo['saveas'] = iif($adduser, $userid . '-') . $imginfo['filename'];
	$imginfo['location'] = $location;

	$imginfo['saveto'] = $folderstring;

	$imginfo['shortname'] = substr($imginfo['filename'], '', strrpos($imginfo['filename'], '.'));
	$imginfo['extension'] = strtolower(substr($imginfo['filename'], strrpos($imginfo['filename'], '.') + 1));

	$imagedata = @getimagesize($imginfo['location']);
	$imginfo['width'] = $imagedata[0];
	$imginfo['height'] = $imagedata[1];
	$imginfo['numericaltype'] = $imagedata[2];
	$imginfo['filesize'] = @filesize($imginfo['location']);

	return array_merge($imageinfo, $imginfo);
}

// ##################### Fetch Category Extension Info ########################
function fetch_cat_ext_info()
{
	global $db, $imageinfo;

	$filetypes = array();
	$gettypes = $db->query_read("SELECT * FROM " . TABLE_PREFIX . "adv_gallery_filetypes WHERE enabled = 1");
	while ($types = $db->fetch_array($gettypes))
	{
		$filetypes["$types[extension]"] = $types;
	}

	$db->free_result($gettypes);
	unset($types);

	$catfiletypes	= array();
	$cattypes = $db->query_read("SELECT catid, disext FROM " . TABLE_PREFIX . "adv_gallery_categories");
	while ($ctypes = $db->fetch_array($cattypes))
	{
		$ftypes = unserialize($ctypes['disext']);
		$catfiletypes["$ctypes[catid]"] = $filetypes;

		if (!empty($ftypes))
		{
			foreach ($ftypes AS $ext => $values)
			{
				if (!$values['enabled'])
				{
					unset($catfiletypes["$ctypes[catid]"]["$ext"]);
				}
				else
				{
					$catfiletypes["$ctypes[catid]"]["$ext"] = $values;
				}
			}
		}
	}

	$db->free_result($cattypes);
	unset($ctypes);


	return $catfiletypes;
}

// ############################### Check Image Errors #########################
function check_upload_errors()
{
	global $imageinfo, $db, $vba_options, $galleryperms, $userinfo, $filetypes, $imgtypearray, $categorycache, $catfiletypes, $categoryperms, $custominfo, $_POST;

	if (!isset($errors))
	{
		$errors = array();
	}

	// No catid
	if (!$imageinfo['catid'])
	{
		eval('$errors[] = "' . fetch_error('adv_gallery_must_choose_category') . '";');
	}

	if (!$categoryperms["$imageinfo[catid]"]['canuploadimages'])
	{
		print_no_permission();
	}

	// Open for images?
	$catopts = construct_cat_opts($imageinfo['catid'], $categorycache["$imageinfo[catid]"]['options']);
	if (!$catopts['open_for_images'] AND $imageinfo['catid'])
	{
		eval('$errors[] = "' . fetch_error('adv_gallery_categoryclosed') . '";');
	}

	// Filesize
	if ($filetypes["$imageinfo[catid]"]["$imageinfo[extension]"]['filesize'] AND $imageinfo['filesize'] > $filetypes["$imageinfo[catid]"]["$imageinfo[extension]"]['filesize'])
	{
		eval('$errors[] = "' . fetch_error('imagetoobig', $filetypes["$imageinfo[catid]"]["$imageinfo[extension]"]['filesize']) . '";');
	}

	// Extensions
	if (!in_array($imageinfo['extension'], array_keys($filetypes["$imageinfo[catid]"])) OR strstr($imageinfo['saveas'], '..'))
	{
		$tempfiletypes = $filetypes["$imageinfo[catid]"];
		if ($categorycache["$imageinfo[catid]"]['disext'])
		{
			foreach ($tempfiletypes AS $ext => $extinfo)
			{
				if (in_array($extinfo['extensionid'], explode(',', $categorycache["$imageinfo[catid]"]['disext'])))
				{
					unset($tempfiletypes["$ext"]);
				}
			}
		}
		eval('$errors[] = "' . fetch_error('adv_gallery_invalid_extension', implode(', ', array_keys($tempfiletypes))) . '";');
	}

	if ((!in_array($imageinfo['numericaltype'], array(1,2,3)) OR $imageinfo['numericaltype'] == 1 AND (!function_exists('imagegif') OR !function_exists('imagecreatefromgif'))) AND in_array($vba_options['gallery_resizemethod'], array('GD1', 'GD2')) AND ($imageinfo['width'] > $filetypes["$imageinfo[catid]"]["$imageinfo[extension]"]['width'] OR $imageinfo['height'] > $filetypes["$imageinfo[catid]"]["$imageinfo[extension]"]['height']))
	{
		eval('$errors[] = "' . fetch_error('adv_gallery_imagetoolarge', $filetypes["$imageinfo[catid]"]["$imageinfo[extension]"]['width'], $filetypes["$imageinfo[catid]"]["$imageinfo[extension]"]['height']) . '";');
	}

	// Illegal filetypes
	if (in_array($imageinfo['extension'], array_keys($imgtypearray)) AND $imgtypearray["$imageinfo[extension]"] != $imageinfo['numericaltype'] AND !in_array($imageinfo['numericaltype'], array(4,13)))
	{
		eval('$errors[] = "' . fetch_error('upload_invalid_file') . '";');
	}

	// Description
	if (strlen($imageinfo['description']) > $vba_options['gallery_desclimit'])
	{
		eval('$errors[] = "' . fetch_error('adv_gallery_description_toolong', vb_number_format(strlen($imageinfo['description'])), $vba_options['gallery_desclimit']) . '";');
	}

	// Required custom fields
	if (!empty($custominfo))
	{
		foreach ($custominfo AS $profilefield)
		{
			if ($profilefield['required'] AND !$_POST["field$profilefield[fieldid]"])
			{
				eval('$errors[] = "' . fetch_error('requiredfieldmissing', $profilefield['title']) . '";');
			}
		}
	}

	return $errors;
}


// ############################## Watermark Image #############################
function watermark_image($type, $perm = false)
{
	global $imageinfo, $vba_options, $imgtypearray, $catoptions;

	if (empty($catoptions["$imageinfo[catid]"]))
	{
		$catoptions["$imageinfo[catid]"] = fetch_adv_category_setting($imageinfo['catid']);
	}

	switch ($type)
	{
		case 'original':
			$imglocation = $imageinfo['saveto'] . '/' . $imageinfo['originalname'];
			$imgheight = $imageinfo['originalheight'];
			$imgwidth = $imageinfo['originalwidth'];
			break;
		default:
			$imglocation = $imageinfo['location'];
			$imgheight = $imageinfo['height'];
			$imgwidth = $imageinfo['width'];
	}

	if (in_array($imageinfo['extension'], array_keys($imgtypearray)))
	{
		$logoinfo = @getimagesize($catoptions["$imageinfo[catid]"]['gallery_watermark']);
		$logo['width'] = $logoinfo[0];
		$logo['height'] = $logoinfo[1];
		$logo['extension'] = substr($catoptions["$imageinfo[catid]"]['gallery_watermark'], strrpos($catoptions["$imageinfo[catid]"]['gallery_watermark'], '.') + 1);

		switch ($catoptions["$imageinfo[catid]"]['gallery_watermark_location']{0})
		{
			case 'n':
				$placementy = 0;
				break;
			case 'm':
				$placementy = round(($imgheight - $logo['height']) / 2);
				break;
			default:
				$placementy = $imgheight - $logo['height'];
		}

		switch($catoptions["$imageinfo[catid]"]['gallery_watermark_location']{1})
		{
			case 'w':
				$placementx = 0;
				break;
			case 'c':
				$placementx = round(($imgwidth - $logo['width']) / 2);
				break;
			default:
				$placementx = $imgwidth - $logo['width'];
		}

		if (in_array($vba_options['gallery_resizemethod'], array('GD1', 'GD2')) OR !$perm)
		{
			if ($imgwidth > $logo['width'] AND $imgheight > $logo['height'] AND in_array($imageinfo['extension'], array('jpg', 'jpeg', 'png')))
			{

				switch($imageinfo['extension'])
				{
					case 'jpg':
					case 'jpeg':
						$mainimage = @imagecreatefromjpeg($imglocation);
						break;
					case 'png':
						$mainimage = @imagecreatefrompng($imglocation);
						break;
				}

				@ImageAlphaBlending($mainimage, true);

				switch ($logo['extension'])
				{
					case 'jpg':
					case 'jpeg':
						$logoimage = @imagecreatefromjpeg($catoptions["$imageinfo[catid]"]['gallery_watermark']);
						break;

					case 'png':
						$logoimage = @imagecreatefrompng($catoptions["$imageinfo[catid]"]['gallery_watermark']);
						break;
				}

				@imagecopy($mainimage, $logoimage, $placementx, $placementy, 0, 0, $logo['width'], $logo['height']);

				switch ($imageinfo['extension'])
				{
					case 'jpg':
					case 'jpeg':
						if ($perm)
						{
							@imagejpeg($mainimage, $imglocation);
						}
						else
						{
							@imagejpeg($mainimage);
						}
						break;
					case 'png':
						if ($perm)
						{
							@imagepng($mainimage, $imglocation);
						}
						else
						{
							@imagepng($mainimage);
						}
						break;
				}

				@imagedestroy($mainimage);
				@imagedestroy($logoimage);
			}
		}
		else
		{
			$IMcommand = '"' . $vba_options['gallery_programpath'] . 'composite" -gravity northwest -geometry +' . $placementx . '+' . $placementy . ' ' . $catoptions["$imageinfo[catid]"]['gallery_watermark'] . ' ' . $imglocation . ' ' . $imglocation;

			@system($IMcommand, $IMerror);
		}
	}
}

// ############################### Rotate Image ###############################
function rotate_image($imageinfo, $angle)
{
	global $vba_options, $folderstring;

	$imgarray = array();

	$imgarray[] = $imageinfo['filename'];
	if ($imageinfo['thumbname'])
	{
		$imgarray[] = $imageinfo['thumbname'];
	}
	if ($imageinfo['originalname'])
	{
		$imgarray[] = $imageinfo['originalname'];
	}

	foreach ($imgarray AS $imagelocation)
	{
		$imagelocation = $folderstring . '/' . $imagelocation;
		switch ($vba_options['gallery_resizemethod'])
		{
			case 'GD1':
			case 'GD2':
				$tempimage = @imagecreatefromjpeg($imagelocation);
				$tempimage = @imagerotate($tempimage, $angle, '#000000');
				@imagejpeg($tempimage, $imagelocation, -1);
				@imagedestroy($tempimage);
				break;

			case 'IM':

				$IMcommand = '"' . $vba_options['gallery_programpath'] . 'convert" -rotate ' . $angle . ' ' . $imagelocation . ' ' . $imagelocation;
				@system($IMcommand, $retval);
		}
	}
}

// ############################## Flip Image ##################################
function flip_image($imageinfo)
{
	global $flip, $vba_options, $folderstring;

	$imgarray = array();

	$imgarray[] = $imageinfo['filename'];
	if ($imageinfo['thumbname'])
	{
		$imgarray[] = $imageinfo['thumbname'];
	}
	if ($imageinfo['originalname'])
	{
		$imgarray[] = $imageinfo['originalname'];
	}

	foreach ($imgarray AS $imglocation)
	{
		$imglocation = $folderstring . '/' . $imglocation;

		$imgsrc = @imagecreatefromjpeg($imglocation);
	  $width = @imagesx($imgsrc);
	  $height = @imagesy($imgsrc);
		$imgdest = @imagecreatetruecolor($width, $height);

		if (sizeof($flip) == 2)
		{
			$flipit = 'both';
		}
		else if (implode(',', $flip) == 'horizontal')
		{
			$flipit = 'flop';
		}
		else
		{
			$flipit = 'flip';
		}

		switch ($vba_options['gallery_resizemethod'])
		{
			case 'GD1':
			case 'GD2':
				for ($x = 0; $x < $width; $x++)
				{
					for ($y = 0 ; $y < $height; $y++)
					{
						switch ($flipit)
						{
							case 'flop':
								imagecopy($imgdest, $imgsrc, $width-$x-1, $y, $x, $y, 1, 1);
								break;
							case 'flip':
								imagecopy($imgdest, $imgsrc, $x, $height-$y-1, $x, $y, 1, 1);
								break;
							case 'both':
								imagecopy($imgdest, $imgsrc, $width-$x-1, $height-$y-1, $x, $y, 1, 1);
								break;
						}
					}
				}

				imagejpeg($imgdest, $imglocation, -1);
				imagedestroy($imgsrc);
				imagedestroy($imgdest);
				break;

			case 'IM':
				$IMcommand = '"' . $vba_options['gallery_programpath'] . 'convert" ' . iif($flipit == 'both', '-flip -flop', '-' . $flipit) . ' ' . $imglocation . ' ' . $imglocation;
				@system($IMcommand, $retval);
		}
	}
}

// ########################### Construct Folder Path ##########################
function construct_folder_path()
{
	global $vba_options, $userid, $vbulletin;

	if ($vba_options['gallery_insafemode'])
	{
		return $vba_options['gallery_filedirectory'];
	}

	$folders = preg_split('//', $userid, -1, PREG_SPLIT_NO_EMPTY);

	$folderstring = $vba_options['gallery_filedirectory'];

	foreach ($folders AS $uid)
	{
		$folderstring .= '/' . $uid;
		if (!is_dir($folderstring))
		{
			@mkdir($folderstring, 0777);
			@chmod($folderstring, 0777);

			if ($fp = @fopen($folderstring . '/index.html', "w"))
			{
				@fputs ($fp, '');
				@fclose($fp);
			}
			else
			{
				eval(standard_error(fetch_error('adv_gallery_problem_creating_folder', $vbulletin->options['webmasteremail'])));
			}
		}
	}
	return $folderstring;
}

// ######################## Fetch Advanced Cat Settings #######################
function fetch_adv_category_setting($catid)
{
	global $db, $vba_options, $adv_category_options;

	$catoptions = array();
	$adv_options = $db->query_first("SELECT adv_setting FROM " . TABLE_PREFIX . "adv_gallery_categories WHERE catid = '$catid'");
	$adv_options = unserialize($adv_options['adv_setting']);

	foreach ($adv_category_options AS $varname)
	{
		$catoptions["$varname"] = iif($adv_options["$varname"], $adv_options["$varname"], $vba_options["$varname"]);
	}

	return $catoptions;
}

?>